clear all
set mem 300m
set more off
prog drop _all
cap log close
set logtype text
set maxiter 50
cd "C:\Helmut_Farbmacher\JAE ivreg3\Table 3 - QoB Simulation\Results" //directory has to be changed

***

global qob_29 QTR120 QTR121 QTR122 QTR123 QTR124 QTR125 QTR126 QTR127 QTR128 QTR129 /*
	*/ QTR220 QTR221 QTR222 QTR223 QTR224 QTR225 QTR226 QTR227 /*
	*/ QTR228 QTR229 QTR320 QTR321 QTR322 QTR323 QTR324 QTR325 QTR326 QTR327 QTR328 QTR329

log using "QoB - Simulation", replace	

local R 100
foreach model in 2sls jive2 cue cuec {
	qui {
	clear all
	set seed 9090
	set obs `R'
	gen obs=.
	gen b_educ=.
	gen se_educ=.
	gen t_educ=.
	save "Simulation_`model'.dta", replace
	forvalues r=1/`R' {
		use "QOB_tableV - simulation.dta", clear
		gen u=uniform()
		keep if u>0.5 & u<0.80
		if "`model'"=="2sls" {
			ivregress 2sls LWKLYWGE (EDUC=$qob_29) YR20-YR28, robust
		}
		if "`model'"=="jive2" {
			jive LWKLYWGE (EDUC=$qob_29) YR20-YR28, ujive2 robust
		}
		if "`model'"=="cue" {
			ivreg3 LWKLYWGE EDUC YR20-YR28, endog(EDUC) exog($qob_29 YR20-YR28)
		}
		if "`model'"=="cuec" {
			ivreg3 LWKLYWGE EDUC YR20-YR28, endog(EDUC) exog($qob_29 YR20-YR28) nwind	
		}
		local obs=_N
		use "Simulation_`model'.dta", clear
		replace obs=`obs' in `r'
		replace b_educ=_b[EDUC] in `r'
		replace se_educ=_se[EDUC] in `r'
		replace t_educ=b_educ/se_educ in `r'
		save "Simulation_`model'.dta", replace
	}
	}
	use "Simulation_`model'.dta", clear
	dis ""
	dis "{txt}*********** {res}`model' {txt} ***********"
	dis ""
	dis "{txt}sum"
	sum
}

***

log close

/*
clear all
set mem 300m
use "QOB_tableV - simulation.dta", clear

global qob_29 QTR120 QTR121 QTR122 QTR123 QTR124 QTR125 QTR126 QTR127 QTR128 QTR129 /*
	*/ QTR220 QTR221 QTR222 QTR223 QTR224 QTR225 QTR226 QTR227 /*
	*/ QTR228 QTR229 QTR320 QTR321 QTR322 QTR323 QTR324 QTR325 QTR326 QTR327 QTR328 QTR329

ivregress 2sls LWKLYWGE (EDUC=$qob_29) YR20-YR28, robust
assert reldif(_b[EDUC],0.0891)<0.0001						//replicate Angrist and Krueger (1991)'s results
*/



